IF OBJECT_ID('P_EST_SNGPC_ENTRADA_INSERIR') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_EST_SNGPC_ENTRADA_INSERIR;
END;
GO

CREATE PROCEDURE P_EST_SNGPC_ENTRADA_INSERIR(@PCODIGOEMPRESA     INT,
                                             @PCODIGOFILIAL      INT,
                                             @PCODIGONOTA        INT,
                                             @PCODIGOMEDICAMENTO INT,
                                             @PCODIGOTIPOENTRADA INT,
                                             @PCODIGOLOTE        INT,
                                             @DATA               DATETIME,
                                             @PQTDE              INT,
                                             @PCODIGOUSUARIO     INT,
                                             @PCODIGOMOVENTRADA  INT,
                                             @PREGISTRO_MS       VARCHAR(MAX),
                                             @PVERSAO            VARCHAR(20))
AS
     SET NOCOUNT ON;
     DECLARE @CODIGO INT;
     DECLARE @OUTTABLE TABLE(ID INT);
     DECLARE @OLDQTDE INT;
     DECLARE @OPERACAO VARCHAR(MAX);
     DECLARE @OLDLOTE INT;
     DECLARE @TOTALLANCADO INT;
     DECLARE @CANCELADO INT
     DECLARE @QTITENNOTA INT
     DECLARE @NEWQTDE INT;
    BEGIN TRY
        --VERIFICAR A QUANTIDADE DESTE LANAMENTO---
        SELECT @OLDQTDE = QT_LOTE,
               @OLDLOTE = CD_LOTE
        FROM 
            EST_SNGPC_ENTRADA (NOLOCK)  
        WHERE 
           CD_ENT_SNGPC = @PCODIGOMOVENTRADA;
        --SOMAR TODOS OS LANAMENTOS PARA A NOTA
        SELECT  
           @TOTALLANCADO = BAIXAS.QT_LOTE 
        FROM                                           
            EST_SNGPC_ENTRADA AS BAIXAS  (NOLOCK)         
        WHERE                                          
            BAIXAS.CD_EMP        = @PCODIGOEMPRESA                   
           AND BAIXAS.CD_FILIAL  = @PCODIGOFILIAL          
           AND BAIXAS.CD_NF      = @PCODIGONOTA                
           AND BAIXAS.CD_PROD    = @PCODIGOMEDICAMENTO  
        --VERIFCAR A QUANTIDADE CANCELADA--
        SELECT 
         @CANCELADO = COALESCE(QT_CANCEL,0),
         @QTITENNOTA  =QT_IT
        FROM
          EST_NF_ENT_IT   IT     
        LEFT JOIN EST_NF_ENT_IT_EST_SNGPC_PENDENTE_CANCELADO CCL  (NOLOCK)  ON
            CCL.CD_EMP            = IT.CD_EMP    
          AND  CCL.CD_FILIAL      = IT.CD_FILIAL
          AND  CCL.CD_NF          = IT.CD_NF      
          AND  CCL.CD_PROD        = IT.CD_PROD           
        WHERE        
          IT.CD_EMP              = @PCODIGOEMPRESA     
          AND  IT.CD_FILIAL      = @PCODIGOFILIAL 
          AND  IT.CD_NF          = @PCODIGONOTA  
          AND  IT.CD_PROD        = @PCODIGOMEDICAMENTO         
       IF (@PQTDE +COALESCE(@TOTALLANCADO,0))  >   (@QTITENNOTA - COALESCE(@CANCELADO,0))  
            RAISERROR('A QUANTIDADE LANADA E MAIOR QUE A QUANTIDADE  DA NOTA ', 16, 1); 
        SET @NEWQTDE = @PQTDE;
        IF @OLDQTDE IS NULL
        BEGIN
                SET @OPERACAO = 'ISERINDO MOV.ENTRADA';
                INSERT INTO EST_SNGPC_ENTRADA
                (CD_EMP,
                 CD_FILIAL,
                 CD_NF,
                 CD_PROD,
                 CD_TP_ENT,
                 CD_LOTE,
                 DT_MOV,
                 QT_LOTE,
                 DT_ULT_ALT,
                 CD_USU
                )
                OUTPUT INSERTED.CD_ENT_SNGPC
                       INTO @OUTTABLE(ID)
                VALUES
                (@PCODIGOEMPRESA,
                 @PCODIGOFILIAL,
                 @PCODIGONOTA,
                 @PCODIGOMEDICAMENTO,
                 @PCODIGOTIPOENTRADA,
                 @PCODIGOLOTE,
                 @DATA,
                 @PQTDE,
                 @DATA,
                 @PCODIGOUSUARIO
                );
                SET @CODIGO =
                (
                    SELECT MAX(ID)
                    FROM @OUTTABLE
                );
            END;
        ELSE
            BEGIN
                SET @OPERACAO = 'ATULIZACAO LANC. ENTRADA';
                IF @OLDLOTE <> @PCODIGOLOTE
                    BEGIN
                        SET @OPERACAO = @OPERACAO+' ALT '+CAST(@OLDLOTE AS VARCHAR)+'  TO '+CAST(@PCODIGOLOTE AS VARCHAR);
                        UPDATE EST_PROD_EST_SNGPC_LOTE_CPL
                          SET
                              QT_LOTE = (QT_LOTE - @OLDQTDE)
                        WHERE CD_EMP = @PCODIGOEMPRESA
                              AND CD_FILIAL = @PCODIGOFILIAL
                              AND CD_LOTE = @OLDLOTE
                              AND (QT_LOTE - @OLDQTDE) >= 0;
                        SET @OLDQTDE = 0;
                    END;
                UPDATE EST_SNGPC_ENTRADA
                  SET
                      CD_TP_ENT = @PCODIGOTIPOENTRADA,
                      DT_MOV = @DATA,
                      QT_LOTE = @PQTDE,
                      DT_ULT_ALT = GETDATE(),
                      CD_USU = @PCODIGOUSUARIO,
                      CD_LOTE = @PCODIGOLOTE
                WHERE CD_ENT_SNGPC = @PCODIGOMOVENTRADA
                      AND CD_EMP = @PCODIGOEMPRESA
                      AND CD_FILIAL = @PCODIGOFILIAL;
                SET @CODIGO = @PCODIGOMOVENTRADA;
            END;
        IF EXISTS
        (
            SELECT CD_LOTE
            FROM EST_PROD_EST_SNGPC_LOTE_CPL
            WHERE CD_EMP = @PCODIGOEMPRESA
                  AND CD_FILIAL = @PCODIGOFILIAL
                  AND CD_LOTE = @PCODIGOLOTE
        )
            BEGIN
                UPDATE EST_PROD_EST_SNGPC_LOTE_CPL
                  SET
                      QT_LOTE = (QT_LOTE - COALESCE(@OLDQTDE, 0)) + @NEWQTDE,
                      REGISTRO_MS = @PREGISTRO_MS
                WHERE CD_EMP = @PCODIGOEMPRESA
                      AND CD_FILIAL = @PCODIGOFILIAL
                      AND CD_LOTE = @PCODIGOLOTE;
            END;
        ELSE
            BEGIN
                SET @OPERACAO = @OPERACAO+' NOVO.LOTE';
                INSERT INTO EST_PROD_EST_SNGPC_LOTE_CPL
                (CD_EMP,
                 CD_FILIAL,
                 CD_LOTE,
                 QT_LOTE,
                 REGISTRO_MS
                )
                VALUES
                (@PCODIGOEMPRESA,
                 @PCODIGOFILIAL,
                 @PCODIGOLOTE,
                 @PQTDE,
                 @PREGISTRO_MS
                );
            END;
        INSERT INTO SNGPC_HIST_MOV_LOTE
        (CD_EMP,
         CD_FILIAL,
         CD_PROD,
         LOTE,
         TIPO_MOV,
         CD_MOV,
         DT_MOV,
         CD_USU,
         QT_MOV,
         VERSAO
        )
        VALUES
        (@PCODIGOEMPRESA,
         @PCODIGOFILIAL,
         @PCODIGOMEDICAMENTO,
         @PCODIGOLOTE,
         @OPERACAO,
         @CODIGO,
         GETDATE(),
         @PCODIGOUSUARIO,
         @PQTDE,
         @PVERSAO
        );
    END TRY
    BEGIN CATCH
        SET @CODIGO = 0;
        SET @DATA = NULL;
        BEGIN TRY
            IF @@TRANCOUNT > 0
                ROLLBACK;
        END TRY
        BEGIN CATCH
        END CATCH;
        SET @OPERACAO = 'ERRO AO GRAVAR ENTRADA '+ERROR_MESSAGE();
        RAISERROR(@OPERACAO, 16, 1);
    END CATCH;
     SELECT @DATA AS DT_ULT_ALT,
            @CODIGO AS CD_ENT_SNGPC;
GO